<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('streets', function (Blueprint $table) {
            if (Schema::hasColumn('streets', 'booth_id')) {
                $table->dropForeign(['booth_id']);
                $table->dropColumn('booth_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('streets', function (Blueprint $table) {
            if (!Schema::hasColumn('streets', 'booth_id')) {
                $table->unsignedBigInteger('booth_id')->nullable();
                // Foreign key restore assumes booths table exists with id
                $table->foreign('booth_id')->references('id')->on('booths')->onDelete('cascade');
            }
        });
    }
};
