<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('image_page_import_logs', function (Blueprint $table) {
            $table->id();
            $table->string('page_path');
            $table->string('status')->default('pending'); // pending|processing|completed|failed
            $table->unsignedInteger('voters_found')->default(0);
            $table->unsignedInteger('voters_imported')->default(0);
            $table->unsignedInteger('voters_failed')->default(0);
            $table->json('errors')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('image_page_import_logs');
    }
};
