<?php
require __DIR__.'/vendor/autoload.php';
$app = require_once __DIR__.'/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$voters = \App\Models\Voter::orderBy('serial_number')->pluck('serial_number')->toArray();
$missing = [];
for ($i = 1; $i <= 210; $i++) {
    if (!in_array($i, $voters)) $missing[] = $i;
}
echo 'Total: ' . count($voters) . PHP_EOL;
echo 'Missing serials: ' . implode(', ', $missing) . PHP_EOL;
echo 'Missing count: ' . count($missing) . PHP_EOL;

// Check row 10 specifically (serials 181-210)
$row10 = array_filter($voters, fn($s) => $s >= 181 && $s <= 210);
echo 'Row 10 count: ' . count($row10) . PHP_EOL;
