<?php

namespace App\Services;

use App\Constants\Constants;
use App\Models\TransactionHistory;
use App\Repositories\AdminRepository;
use App\Repositories\BookingRepository;
use App\Repositories\MemberRepository;
use App\ResponseHandler\Response;
use App\Validations\Validation;

use App\Repositories\TransactionRepository;
use App\Repositories\UserRepository;
use Barryvdh\DomPDF\Facade\Pdf;
use Carbon\Carbon;
use DateTime;
use DateTimeZone;
use Illuminate\Http\Response as LaravelResponse;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Symfony\Component\HttpFoundation\Response as HttpFoundationResponse;

class AdminService
{

    protected $adminRepository;
    protected $response;
    protected $validation;
    protected $rentalCarRepository;
    protected $packageRepository;
    protected $bookingRepository;
    protected $transactionRepository;
    protected $cartRepository;
    protected $inappTourPackageRepository;
    protected $inappCarPackageRepository;

    protected $userDetailsRepository;

    protected $memberRepository;

    protected $mailService;

    public function __construct(
        AdminRepository $adminRepository,
        Response $response,
        Validation $validation,
        // BookingRepository $bookingRepository,
        // TransactionRepository $transactionRepository,
        // MailService $mailService,
        // UserRepository $userDetails,
        // MemberRepository $memberRepository
    ) {
        $this->adminRepository = $adminRepository;
        $this->response = $response;
        $this->validation = $validation;
        // $this->bookingRepository = $bookingRepository;
        // $this->transactionRepository = $transactionRepository;
        // $this->mailService = $mailService;
        // $this->userDetailsRepository = $userDetails;
        // $this->memberRepository = $memberRepository;
    }

    public function createAdmin($data)
    {
        $validationResponse = $this->validation->validationForAdmin($data);

        $responseData = $validationResponse->getData();

        if ($responseData->status == Constants::SUCCESS_CODE) {

            $admin = $this->adminRepository->createAdmin($data);
        } else {
            return $this->response->respondWithError($responseData->message, $responseData->status, $responseData->status);
        }

        return $admin
            ? $this->response->respondWithData('Admin created successfully.', $admin, new LaravelResponse)
            : $this->response->respondWithError('Error while creating Admin.');
    }

    public function getAdminById($id)
    {
        $admin = $this->adminRepository->getAdminById($id);

        return $admin
            ?  $this->response->respondWithData('Retrieved successfully.', $admin, new LaravelResponse)
            : $this->response->respondWithError('No admin found.');
    }

    public function loginAdmin($requestData)
    {
        $username = $requestData['username'];
        $password = $requestData['password'];

        if (empty($usernaeme) && empty($password)) {
            return $this->response->respondWithError('Please enter the username and password');
        }

        if (empty($username)) {
            return $this->response->respondWithError('Please enter the username');
        }

        if (empty($password)) {
            return $this->response->respondWithError('Please enter the password');
        }


        $admin = $this->adminRepository->loginAdmin($username, $password);

        return $admin
            ?  $this->response->respondWithData('Logged In Successfully', $admin, new LaravelResponse)
            : $this->response->respondWithError('Please check the username or password');
    }



    function convertIstToUst($date)
    {

        // Set the timezone to UTC
        $date->setTimezone(new DateTimeZone('UTC'));
        // Return the formatted date in UTC
        return $date->format('Y-m-d H:i:s'); // Format as per your requirement
    }


 

    public function getAllAdmin()
    {
        $admin = $this->adminRepository->getAllAdmin();

        return (empty($admin) == true)
            ? $this->response->respondWithError('No admin found.')
            : $this->response->respondWithData('Retrieved successfully.', $admin, new LaravelResponse);
    }

    public function getAllDeletedAdmin()
    {
        $deletedAdmin = $this->adminRepository->getAllDeletedAdmin();

        return $deletedAdmin->isEmpty()
            ? $this->response->respondWithError('No admin found.')
            : $this->response->respondWithData('Retrieved Successfully.', $deletedAdmin, new LaravelResponse);
    }

    public function updateAdminById($id, array $data)
    {

        $existingAdmin = $this->adminRepository->findAdminById($id);

        if (!$existingAdmin) {
            return $this->response->respondWithError('No admin found.');
        }

        $validationResponse = $this->validation->validationForAdmin($data);

        $responseData = $validationResponse->getData();

        if ($responseData->status == Constants::SUCCESS_CODE) {
            $response = $this->adminRepository->updateAdminById($id, $data);
        } else {
            return $this->response->respondWithError($responseData->message);
        }

        return ($response == 1)
            ? $this->response->respondWithData('Admin updated successfully.', $this->adminRepository->findAdminById($id), new LaravelResponse)
            : $this->response->respondWithError('Error while updating Admin.');
    }

    public function deleteAdminById($id)
    {
        $existingAdmin = $this->adminRepository->findAdminById($id);

        if (!$existingAdmin) {
            return $this->response->respondWithError('No admin found.');
        }

        $result = $this->packageRepository->deletePackageById($id);

        return $result
            ? $this->response->respondWithData('Deleted successfully', null, new LaravelResponse)
            : $this->response->respondWithError('Error while deleting Admin.');
    }

    



}
