<?php

namespace App\ResponseHandler;

use App\Constants\Constants;
use App\Security\AESUtils;

use Illuminate\Http\Response as LaravelResponse;


class Response
{
    public function respondWithData($message, $data, LaravelResponse $response)
    {
        $responseData = [
            'status' => Constants::SUCCESS_CODE,
            'message' => $message
        ];

        if ($data !== null) {
            // Encrypt data if it is provided
            $encryptedResponse = AESUtils::encrypt(json_encode($data), Constants::ENCRYPTION_KEY);
            $responseData['data'] = $encryptedResponse;
        }

        // Return the response with a JSON payload
        return response()->json($responseData, 200)  // You can also specify a status code, like 200
            ->header('Content-Type', 'application/json');  // Set the Content-Type header
    }

    public function respondWithError($message)
    {
        // Using Laravel's response helper for error responses
        return response()->json([
            'status' => Constants::INVALID_PARAMS,
            'message' => $message
        ], Constants::INVALID_PARAMS);
    }

    public function responseForNotFound($message)
    {
        // Using Laravel's response helper for error responses
        return response()->json([
            'status' => Constants::NOT_FOUND,
            'message' => $message
        ], Constants::NOT_FOUND);
    }
}
