<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class RationCard extends Model
{
    protected $table = 'ration_cards';
    protected $fillable = [
        'ration_card_number',
        'address',
        'head_photo', 
        'other_state',
        'is_deleted'
    ];
    public function voters()
    {
        // Only fetch voters that are not deleted
        return $this->hasMany(Voter::class, 'ration_card_id', 'id')
                    ->where('is_deleted', false);
    }

    /**
     * Get all gifts received by this ration card
     */
    public function receivedGifts()
    {
        return $this->hasMany(GiftedRationCard::class, 'ration_card_number', 'ration_card_number')
                    ->where('is_deleted', false);
    }

    /**
     * Check if this ration card has received a specific gift
     */
    public function hasReceivedGift($giftId)
    {
        return $this->receivedGifts()->where('gift_id', $giftId)->exists();
    }
}
