<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Gift extends Model
{
    protected $table = 'gifts'; // Define the table as 'gifts'

    protected $fillable = ['gift_name'];

    /**
     * Get all ration cards that received this gift
     */
    public function giftedRationCards()
    {
        return $this->hasMany(GiftedRationCard::class, 'gift_id', 'id')
                    ->where('is_deleted', false);
    }

    /**
     * Get all distributed ration card numbers for this gift
     */
    public function getDistributedRationCardNumbers()
    {
        return $this->giftedRationCards()->pluck('ration_card_number')->toArray();
    }
}
