<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\Response as LaravelResponse;
use App\ResponseHandler\Response;
use App\Services\StreetService;
use App\Security\DecryptUtils;
use App\Validations\Validation;
use App\Constants\Constants;    

class StreetController extends Controller
{

    protected $streetService;
    protected $response;

   public function __construct(StreetService $streetService, Response $response)
    {
        $this->streetService = $streetService;
        $this->response = $response;
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

// Create Street
public function create(Request $request)
{
    $data = $request->getContent();

    if (empty($data)) {
        return $this->response->respondWithError('Request data is empty');
    }

    // Step 2: Decrypt the incoming data
    $decryptedData = DecryptUtils::decryptRequestData($data);

    // Step 3: Ensure it’s a valid array
    if ($decryptedData == null || !is_array($decryptedData)) {
        return $this->response->respondWithError('Invalid or empty request data');
    }

    // Step 4: Validation
    $validation = Validation::validationForStreet($decryptedData);
    if ($validation->getStatusCode() !== Constants::SUCCESS_CODE) {
        return $validation; // return validation error
    }

    // Step 5: Pass to service (same as Gift)
    return $this->streetService->createStreet($decryptedData);
}

    // Get All Streets
    public function getAllStreets()
    {
        return $this->streetService->getAllStreets();
    }

    // Update Street
    public function editStreet(Request $request, $streetId)
    {
        // Step 1: Get raw encrypted JSON
        $data = $request->getContent();

        if (empty($data)) {
            return $this->response->respondWithError('Request data is empty');
        }

        // Step 2: Decrypt
        $decryptedData = DecryptUtils::decryptRequestData($data);

        if ($decryptedData == null || !is_array($decryptedData)) {
            return $this->response->respondWithError('Invalid or empty request data');
        }

        // Step 3: Validate just like create
        $validation = Validation::validationForStreet($decryptedData);
        if ($validation->getStatusCode() !== Constants::SUCCESS_CODE) {
            return $validation;
        }

        // Call the service to update the street by its unique ID and pass the new data
        return $this->streetService->updateStreet($streetId, $decryptedData);
    }

    // Delete Street (soft delete)
    public function deleteStreet($streetId)
    {
        if (empty($streetId)) {
            return $this->response->respondWithError('Street ID is required');
        }

        // Directly return the response from the service
        return $this->streetService->deleteStreet($streetId);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
