<?php

namespace App\Http\Controllers;

use App\Services\BoothService;
use App\Services\VoterService; // Assuming you have a VoterService
use App\Services\RationCardService; // Assuming you have a RationCardService
use App\ResponseHandler\Response;

class DashboardController extends Controller
{
    protected $boothService;
    protected $voterService; // Add voter service
    protected $rationCardService; // Add ration card service
    protected $response;

    public function __construct(
        BoothService $boothService,
        RationCardService $rationCardService, // Inject ration card service
        VoterService $voterService, // Inject voter service
        Response $response
    ) {
        $this->boothService = $boothService;
        $this->voterService = $voterService;
        $this->rationCardService = $rationCardService;
        $this->response = $response;
    }

    // Add this method to fetch all counts
    public function getDashboardCounts()
    {
        try {
            $voterCount = $this->voterService->getVoterCount();
            $rationCardCount = $this->rationCardService->getRationCardCount();
            $boothCount = $this->boothService->getBoothCount();

            return response()->json([
                'status' => 200,
                'message' => 'Data fetched successfully',
                'data' => [
                    'voter_count' => $voterCount,
                    'ration_card_count' => $rationCardCount,
                    'booth_count' => $boothCount
                ]
            ], 200);
        } catch (\Exception $e) {
            return $this->response->respondWithError('Error fetching dashboard counts: ' . $e->getMessage());
        }
    }

    // Your other existing methods...
}
