<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\VoterImageImportService;

class ImportVoterImagesCommand extends Command
{
    protected $signature = 'voter:image-import {directory=Output} {--booth=} {--limit=}';
    protected $description = 'Dispatch OCR import jobs for voter list page images in a directory.';

    public function handle(VoterImageImportService $service): int
    {
        $directory = $this->argument('directory');
        $booth = $this->option('booth');
        $limit = $this->option('limit');
        $limit = $limit !== null ? (int)$limit : null;

        $this->info("Scanning directory: {$directory}");
        $result = $service->dispatchForDirectory(base_path($directory), $booth, $limit);

        if (!$result['success']) {
            $this->error($result['error']);
            return Command::FAILURE;
        }

        $this->info('Jobs dispatched: '.$result['jobs_dispatched']);
        return Command::SUCCESS;
    }
}
