<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            if (!Schema::hasColumn('voters', 'date_of_birth')) {
                $table->date('date_of_birth')->nullable()->after('year_of_birth');
            }
            if (!Schema::hasColumn('voters', 'anniversary_date')) {
                $table->date('anniversary_date')->nullable()->after('date_of_birth');
            }
            if (!Schema::hasColumn('voters', 'voter_image')) {
                $table->string('voter_image')->nullable()->after('street_name');
            }
        });
    }

    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
            $table->dropColumn(['date_of_birth', 'anniversary_date', 'voter_image']);
        });
    }
};
