<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('grievances', function (Blueprint $table) {
            $table->id();
            $table->string('voter_id')->nullable();
            $table->string('ration_card_number')->nullable();
            $table->string('title', 160);
            $table->text('description')->nullable();
            $table->enum('status', ['OPEN', 'IN_PROGRESS', 'CLOSED', 'UNRESOLVED', 'HOLD'])->default('OPEN');
            $table->date('meeting_date')->nullable();
            $table->dateTime('reported_at')->default(DB::raw('CURRENT_TIMESTAMP'));
            $table->date('target_resolve_by')->nullable();
            $table->dateTime('closed_at')->nullable();
            $table->timestamps();

            // Indexes for better query performance
            $table->index('voter_id');
            $table->index('ration_card_number');
            $table->index('status');
            $table->index('target_resolve_by');
            $table->index('reported_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('grievances');
    }
};
