<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('survey_voters', function (Blueprint $table) {
            $table->id();
            $table->foreignId('survey_id')->constrained('surveys')->onDelete('cascade');
            $table->string('voter_id');
            $table->string('booth_id')->nullable();
            $table->foreignId('street_id')->nullable()->constrained('streets')->onDelete('set null');
            $table->tinyInteger('rating')->default(0)->comment('0=No idea, 1=Will not vote, 2=Maybe (50:50), 3=Will vote');
            $table->timestamps();
            
            // Ensure unique voter per survey
            $table->unique(['survey_id', 'voter_id']);
            
            // Indexes for performance
            $table->index('survey_id');
            $table->index('voter_id');
            $table->index('rating');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('survey_voters');
    }
};
