<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('voters', function (Blueprint $table) {
            Schema::table('voters', function (Blueprint $table) {
            // Remove the old column
            if (Schema::hasColumn('voters', 'relation_to_head')) {
                $table->dropColumn('relation_to_head');
            }

            // Add mobile_number column (10 characters)
            if (!Schema::hasColumn('voters', 'mobile_number')) {
                $table->string('mobile_number', 10)->nullable()->after('booth_number');
            }
        });
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('voters', function (Blueprint $table) {
             Schema::table('voters', function (Blueprint $table) {
            // Rollback changes
            if (!Schema::hasColumn('voters', 'relation_to_head')) {
                $table->string('relation_to_head')->nullable()->after('is_head');
            }

            if (Schema::hasColumn('voters', 'mobile_number')) {
                $table->dropColumn('mobile_number');
            }
        });
        });
    }
};
