<?php

namespace App\Services;

class EnvironmentService
{
    /**
     * Get current environment configuration
     */
    public static function getConfig($key = null)
    {
        $env = config('app.env', 'development');
        $envConfig = config("environment.{$env}", []);
        
        if ($key) {
            return data_get($envConfig, $key);
        }
        
        return $envConfig;
    }
    
    /**
     * Check if current environment is development
     */
    public static function isDevelopment()
    {
        return config('app.env') === 'development';
    }
    
    /**
     * Check if current environment is staging
     */
    public static function isStaging()
    {
        return config('app.env') === 'staging';
    }
    
    /**
     * Check if current environment is production
     */
    public static function isProduction()
    {
        return config('app.env') === 'production';
    }
    
    /**
     * Get API rate limit for current environment
     */
    public static function getApiRateLimit()
    {
        return self::getConfig('api_rate_limit') ?? 100;
    }
    
    /**
     * Get cache TTL for current environment
     */
    public static function getCacheTtl()
    {
        return self::getConfig('cache_ttl') ?? 3600;
    }
    
    /**
     * Check if debug mode is enabled
     */
    public static function isDebugMode()
    {
        return self::getConfig('debug_mode') ?? false;
    }
}