<?php

namespace App\Repositories;

use App\Models\Admin;
use App\Models\Subscriber;
use Illuminate\Support\Facades\Hash;

class AdminRepository
{

    protected $admin;

    public function __construct(Admin $admin)
    {
        $this->admin = $admin;
    }

    public function createAdmin(array $data)
    {
        return $this->admin::create($data);
    }

    // public function loginAdmin($username, $password)
    // {
    //     return $this->admin::where('username', $username)->where('password', $password)->where('is_deleted', false)->first();
    // }

public function loginAdmin($username, $password)
{
    // Step 1: Find admin by username
    $admin = $this->admin::where('username', $username)
        ->where('is_deleted', false)
         ->where('password', $password)
        ->first();

    // Step 2: Check if user exists and password is correct
    if ($admin) {
        return $admin; // ✅ Login success
    }

    // Step 3: Return null or false if invalid
    return null; // ❌ Invalid credentials
}

    public function getAdminById($id)
    {
        return $this->admin::where('id', $id)->where('is_deleted', false)->first();
    }

    public function getAllAdmin()
    {
        return $this->admin::where('is_deleted', false)->get();
    }

    public function getAllDeletedAdmin()
    {
        return $this->admin::where('is_deleted', true)->get();
    }

    public function updateAdminById($id, array $data)
    {
        return $this->admin::where('id', $id)->update($data);
    }

    public function deleteAdminById($id)
    {
        return $this->admin::where('id', $id)->update(['is_deleted' => true]);
    }

    public function findAdminById($id)
    {
        return $this->admin::where('id', $id)->where('is_deleted', false)->first();
    }

    public function findAdminByUsername($username)
    {
        return $this->admin::where('username', $username)->where('is_deleted', false)->first();
    }

    public function updateAdminPasswordById($id, $newPassword)
    {
        return $this->admin::where('id', $id)->update(['password' => $newPassword]);
    }
}
