<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Caste;
use App\Models\Category;

class Voter extends Model
{
    use HasFactory;

    protected $table = 'voters'; // make sure this matches your DB table name
    protected $fillable = [
        'serial_number',
        'ration_card_id',
        'voter_id_number', // EPIC number
        'name',
        'relation_type',
        'relation_name',
        'house_number',
        'age',
        'gender',
        'year_of_birth',
        'is_head',
        'booth_id',
        'booth_number',
        'mobile_number',
        'aadhar_number', // ✅ Added new column
        'street_id',     // ✅ Added street ID column
        'street_name',   // ✅ Added street name column
        'ward_no',       // ✅ Added ward number column
        'caste',         // ✅ Added caste column (legacy string)
        'category',      // ✅ Added category column (legacy string)
        'caste_id',      // ✅ New caste_id referencing `castes` table
        'category_id',   // ✅ New category_id referencing `categories` table
        'voter_image',   // ✅ Added voter image column
        'date_of_birth', // ✅ Added date of birth column
        'anniversary_date', // ✅ Added anniversary date column
        'is_deleted',    // ✅ Added is_deleted column
    ];

    /**
     * The attributes that should be cast to dates.
     *
     * @var array
     */
    protected $dates = [
        'date_of_birth',
        'anniversary_date',
    ];

    public function rationCard()
    {
        return $this->belongsTo(RationCard::class);
    }

    // Define the relationship to Booth using booth_id (foreign key)
    public function booth()
    {
        return $this->belongsTo(Booth::class, 'booth_id', 'id');
    }

    // Define the relationship to Street
    public function street()
    {
        return $this->belongsTo(Street::class, 'street_id', 'id');
    }

    public function casteRelation()
    {
        return $this->belongsTo(Caste::class, 'caste_id', 'id');
    }

    public function categoryRelation()
    {
        return $this->belongsTo(Category::class, 'category_id', 'id');
    }
}

