<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ImagePageImportLog extends Model
{
    protected $fillable = [
        'page_path',
        'status',
        'voters_found',
        'voters_imported',
        'voters_failed',
        'errors',
    ];

    protected $casts = [
        'errors' => 'array',
    ];

    public function markProcessing(): void
    {
        $this->update(['status' => 'processing']);
    }

    public function markCompleted(int $found, int $imported, int $failed): void
    {
        $this->update([
            'status' => 'completed',
            'voters_found' => $found,
            'voters_imported' => $imported,
            'voters_failed' => $failed,
        ]);
    }

    public function markFailed(array $errors): void
    {
        $this->update([
            'status' => 'failed',
            'errors' => $errors,
        ]);
    }
}
