<p align="center"><a href="https://laravel.com" target="_blank"><img src="https://raw.githubusercontent.com/laravel/art/master/logo-lockup/5%20SVG/2%20CMYK/1%20Full%20Color/laravel-logolockup-cmyk-red.svg" width="400" alt="Laravel Logo"></a></p>

<p align="center">
<a href="https://github.com/laravel/framework/actions"><img src="https://github.com/laravel/framework/workflows/tests/badge.svg" alt="Build Status"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/dt/laravel/framework" alt="Total Downloads"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/v/laravel/framework" alt="Latest Stable Version"></a>
<a href="https://packagist.org/packages/laravel/framework"><img src="https://img.shields.io/packagist/l/laravel/framework" alt="License"></a>
</p>

# Constituency Management API

A comprehensive Laravel-based API for managing constituency data including ration cards, voters, booths, streets, surveys, gifts, SMS campaigns, and grievances.

## 📚 Feature Documentation

- **[Grievance Management](GRIEVANCE_API_DOCUMENTATION.md)** - Complete API documentation for grievance tracking
- **[Grievance Quick Reference](GRIEVANCE_QUICK_REFERENCE.md)** - Quick reference guide
- **[Grievance Implementation Summary](GRIEVANCE_IMPLEMENTATION_SUMMARY.md)** - Technical implementation details
- **[Gift Distribution API](GIFT_DISTRIBUTION_API.md)** - Gift distribution tracking
- **[Large Export Optimization](LARGE_EXPORT_OPTIMIZATION.md)** - Excel export optimization guide
- **[Environment Guide](ENVIRONMENT_GUIDE.md)** - Environment configuration

## 🚀 Key Features

### Ration Card & Voter Management
- Create, update, and delete ration cards with voter information
- Search by ration card number or voter ID
- Excel import/export functionality
- Track voters by booth and street

### Survey Management
- Create surveys to track voter sentiment
- Rate voters: No idea (0), Will not vote (1), Maybe (2), Will vote (3)
- View booth-wise and street-wise survey breakdowns
- Track survey progress with rating analytics

### Grievance Management ⭐ NEW
- Track public grievances linked to voters/ration cards
- Status-based workflow: OPEN, IN_PROGRESS, CLOSED, UNRESOLVED, HOLD
- Tab-based UI support with smart sorting by target resolution date
- Filter by status, voter ID, or ration card number
- Single form for both create and update operations

### Gift Distribution
- Track gift distribution to ration card holders
- Mark recipients as gifted/not gifted
- Export gifted and pending lists
- Distribution analytics

### SMS Campaigns
- Send SMS to all head voters
- Send to gifted ration card holders
- Send to pending (non-gifted) holders
- Custom SMS with manual mobile numbers

### Booth & Street Management
- Manage polling booths with addresses
- Organize voters by streets
- Link streets to booths

## About Laravel

Laravel is a web application framework with expressive, elegant syntax. We believe development must be an enjoyable and creative experience to be truly fulfilling. Laravel takes the pain out of development by easing common tasks used in many web projects, such as:

- [Simple, fast routing engine](https://laravel.com/docs/routing).
- [Powerful dependency injection container](https://laravel.com/docs/container).
- Multiple back-ends for [session](https://laravel.com/docs/session) and [cache](https://laravel.com/docs/cache) storage.
- Expressive, intuitive [database ORM](https://laravel.com/docs/eloquent).
- Database agnostic [schema migrations](https://laravel.com/docs/migrations).
- [Robust background job processing](https://laravel.com/docs/queues).
- [Real-time event broadcasting](https://laravel.com/docs/broadcasting).

Laravel is accessible, powerful, and provides tools required for large, robust applications.

## Run locally on your LAN

To expose the dev server to other devices on your network (same Wi‑Fi/LAN):

- Start the server bound to all interfaces (port 8001 recommended):
	- Laravel (recommended):
		- php artisan serve --host=0.0.0.0 --port=8001
	- PHP built-in with router (uses project `server.php`):
		- php -S 0.0.0.0:8001 server.php
	- Or via Composer scripts:
		- composer run serve-lan
		- composer run serve-lan-php
- Find your machine IP: ifconfig | grep "inet " | grep -v 127.0.0.1
- From another device, visit: http://<your-ip>:8001

Notes (macOS):
- Allow incoming connections for "php" in System Settings > Network > Firewall > Options.
- Ensure both devices are on the same network and VPN is off. Some guest/corporate networks block peer-to-peer.

After changing .env or config, clear caches so new values take effect:
- php artisan config:clear
- php artisan optimize:clear

Troubleshooting IP access:
- Confirm the server is bound to all interfaces: lsof -nP -iTCP:8001 | grep LISTEN
- Test locally by IP: curl -i "http://$(ipconfig getifaddr en0):8001/api/booth/getAll"
- If unreachable by IP but localhost works, check macOS Firewall allows incoming for php and that both devices are on the same LAN (no guest/isolated network).

Quick sanity checks:
- GET /api/create-test-admin → creates/returns a test admin (guest/123456)
- POST /api/admin/login with {"username":"guest","password":"123456"}

## Learning Laravel

Laravel has the most extensive and thorough [documentation](https://laravel.com/docs) and video tutorial library of all modern web application frameworks, making it a breeze to get started with the framework.

You may also try the [Laravel Bootcamp](https://bootcamp.laravel.com), where you will be guided through building a modern Laravel application from scratch.

If you don't feel like reading, [Laracasts](https://laracasts.com) can help. Laracasts contains over 2000 video tutorials on a range of topics including Laravel, modern PHP, unit testing, and JavaScript. Boost your skills by digging into our comprehensive video library.

## Laravel Sponsors

We would like to extend our thanks to the following sponsors for funding Laravel development. If you are interested in becoming a sponsor, please visit the Laravel [Patreon page](https://patreon.com/taylorotwell).

### Premium Partners

- **[Vehikl](https://vehikl.com/)**
- **[Tighten Co.](https://tighten.co)**
- **[Kirschbaum Development Group](https://kirschbaumdevelopment.com)**
- **[64 Robots](https://64robots.com)**
- **[Cubet Techno Labs](https://cubettech.com)**
- **[Cyber-Duck](https://cyber-duck.co.uk)**
- **[Many](https://www.many.co.uk)**
- **[Webdock, Fast VPS Hosting](https://www.webdock.io/en)**
- **[DevSquad](https://devsquad.com)**
- **[Curotec](https://www.curotec.com/services/technologies/laravel/)**
- **[OP.GG](https://op.gg)**
- **[WebReinvent](https://webreinvent.com/?utm_source=laravel&utm_medium=github&utm_campaign=patreon-sponsors)**
- **[Lendio](https://lendio.com)**

## Contributing

Thank you for considering contributing to the Laravel framework! The contribution guide can be found in the [Laravel documentation](https://laravel.com/docs/contributions).

## Code of Conduct

In order to ensure that the Laravel community is welcoming to all, please review and abide by the [Code of Conduct](https://laravel.com/docs/contributions#code-of-conduct).

## Security Vulnerabilities

If you discover a security vulnerability within Laravel, please send an e-mail to Taylor Otwell via [taylor@laravel.com](mailto:taylor@laravel.com). All security vulnerabilities will be promptly addressed.

## License

The Laravel framework is open-sourced software licensed under the [MIT license](https://opensource.org/licenses/MIT).
