# Ration Card Only API Documentation

## Overview
This API allows you to create a ration card without voters. This is useful when you want to create the ration card first and add voters separately at a later time.

## Endpoint
**POST** `/api/rationCard/create-only`

## Request Format
- **Content-Type**: `application/json`
- **Body**: Encrypted JSON data using AES encryption

### Decrypted JSON Structure
```json
{
    "ration_card_number": "string (required)",
    "address": "string (required)", 
    "other_state": boolean (optional, defaults to false)
}
```

### Required Fields
- `ration_card_number`: Unique ration card number
- `address`: Complete address of the ration card holder

### Optional Fields
- `other_state`: Boolean indicating if the ration card is from another state (defaults to false)

## Response Format

### Success Response (201 Created)
```json
{
    "status": 201,
    "message": "Ration Card created successfully (without voters)",
    "data": {
        "id": 123,
        "ration_card_number": "RC123456789",
        "address": "123 Main Street, City, State",
        "other_state": false,
        "is_deleted": false,
        "created_at": "2025-11-19T10:30:00.000000Z",
        "updated_at": "2025-11-19T10:30:00.000000Z"
    }
}
```

### Error Responses

#### Validation Error (422 Unprocessable Entity)
```json
{
    "status": 422,
    "message": "Ration card number is required"
}
```
```json
{
    "status": 422,
    "message": "Address is required"
}
```

#### Duplicate Ration Card (409 Conflict)
```json
{
    "status": 409,
    "message": "Ration card number already exists"
}
```

#### Invalid Request Data (400 Bad Request)
```json
{
    "status": 400,
    "message": "Invalid or empty request data"
}
```

## Example Usage

### Sample Request (Decrypted)
```json
{
    "ration_card_number": "RC123456789",
    "address": "123 Main Street, Constituency Area, City, State - 123456",
    "other_state": false
}
```

### Sample Response
```json
{
    "status": 201,
    "message": "Ration Card created successfully (without voters)",
    "data": {
        "id": 45,
        "ration_card_number": "RC123456789",
        "address": "123 Main Street, Constituency Area, City, State - 123456",
        "other_state": false,
        "is_deleted": false,
        "created_at": "2025-11-19T10:30:00.000000Z",
        "updated_at": "2025-11-19T10:30:00.000000Z"
    }
}
```

## Key Differences from Regular Ration Card Creation
1. **No voters required**: This endpoint doesn't accept or validate voter information
2. **Simplified validation**: Only validates basic ration card fields
3. **Faster processing**: No need to process multiple voter records
4. **Separate voter addition**: Voters can be added later using voter creation APIs

## Use Cases
- **Bulk ration card setup**: Create ration cards first, then import voters from Excel/CSV
- **Phased data entry**: Register ration cards during initial setup, add family members later
- **Data migration**: When migrating from legacy systems where ration card and voter data come from different sources
- **Administrative efficiency**: Allow different staff members to handle ration card registration and voter enrollment

## Security
- Uses the same AES encryption/decryption as other APIs
- Validates for duplicate ration card numbers
- Follows standard authentication and authorization patterns

## Next Steps
After creating a ration card using this API:
1. Use voter creation APIs to add family members
2. Link voters to the ration card using the ration card ID
3. Update ration card details if needed using the edit endpoint

## Related APIs
- `POST /api/rationCard/create` - Create ration card with voters
- `POST /api/voters/create` - Create individual voters
- `PUT /api/rationCard/edit/{id}` - Update ration card details
- `GET /api/rationCard/get/{id}` - Get ration card details